//Program to find out Economic load dispatch neglecting losses//
//This program requires user input. A sample problem with user input and output is available in the result file//
//Question and result of example problem is available in file "EDwithoutLoss.jpg"
//Scilab Version 5.5.2 ; OS:Windows

clear;
clc;
n=input('Enter no. of units :');
F=input('Enter the cost coefficient in matrix form :');
constraint=input('Enter min and max values of P for all units:');
pd=input('Enter total demand:');
a=F(:,1);b=F(:,2);c=F(:,3);
Pmin=constraint(:,1);
Pmax=constraint(:,2);
chk=zeros(n,1);
rem=1;
while rem==1
    sx=0;sy=0;
    for i=1:n
        if i~=chk(i)
            sx=sx+b(i)/(2*a(i));
            sy=sy+1/(2*a(i));
        end
    end
    lamda=(pd+sx)/sy;
    sch=0;
    for i=1:n
       if i~=chk(i)
            P(i)=(lamda-b(i))/(2*a(i));
            if P(i)<Pmin(i)|P(i)>Pmax(i)
                if P(i)< Pmin(i)
                    P(i)=Pmin(i);
                else
                    P(i)=Pmax(i);
                end
                pd=pd-P(i);
                chk(i)=i;
                sch=sch+1;
            end
        end
        if sch==0
            rem=0;
        else
            rem=1;
        end
    end
end
disp('The optimum schedule is:')
print(%io(2),P)

//SAMPLE INPUT
//Enter no. of units :3
//Enter the cost coefficient in matrix form :[0.05 23.5 700;0.2 20 850;0.09 18 960]
//Enter min and max values of P for all units:[40 150;40 150;40 150]
//Enter total demand:275
 
 //OUTPUT
// The optimum schedule is:   
// P  =
 
//    130.53846  
//    41.384615  
//    103.07692  


